* Title: 	brfss_clean.do
* Version: 	23 May 2018
* Purpose: 	Clean data from IPUMS ATUS extract and create new variables


*******************************************************************************
* (0) Start of file
*******************************************************************************

capture log close
log using log/atus_clean, replace
set more off
clear all
macro drop _all


*******************************************************************************
* (1) Load data for prime-age men
*******************************************************************************

forval year = 2005/2016 {
	use  _state _ageg5yr sex employ* income2 lsatisfy physhlth menthlth qlactlm2 *wt ///
		using dta/raw/brfss/`year', clear

	* Keep only prime-age men
	keep if sex == 1 & _ageg5yr>=2 & _ageg5yr<=7
	
	* Drop U.S. territories
	drop if _state == 66 | _state == 72 | _state == 78
	
	cap rename employ1 employ
	gen year = `year'

	tempfile `year'
	save ``year''
}

use `2005', clear
forval year = 2006/2016 {
	append using ``year''
}


*******************************************************************************
* (2) Create new variables (core/geography)
*******************************************************************************
				 
* Merge with indicator for region
rename _state statefip
merge m:1 statefip using dta/state_region, assert(matched) nogen


*******************************************************************************
* (3) Create new variables (employment)
*******************************************************************************

* Indicator for employment status
gen Employed = .
replace Employed = 1 if (employ == 1 | employ == 2)
replace Employed = 2 if (employ > 2 & employ < 9)


*******************************************************************************
* (4) Create new variables (life satisfaction/physical health problems)
*******************************************************************************

* Indicator for low life satisfaction
gen LowSat = .
replace LowSat = 0 if (lsatisfy == 1 | lsatisfy == 2)
replace LowSat = 1 if (lsatisfy == 3 | lsatisfy == 4)

* Indicator for 10+ days with bad physical health
gen HealthSevere = .
replace HealthSevere = 0 if (physhlth>=1  & physhlth<=9) | physhlth == 88
replace HealthSevere = 1 if (physhlth>=10 & physhlth<=30)

* Indicator for 10+ days with bad mental health
gen MentalHealthSevere = .
replace MentalHealthSevere = 0 if (menthlth>=1  & menthlth<=9) | menthlth == 88
replace MentalHealthSevere = 1 if (menthlth>=10 & menthlth<=30)

* Indicator for activity limitations due to physical/mental/emotional problems
gen Limit = .
replace Limit = 0 if (qlactlm2 == 1 | qlactlm2 == 2)
replace Limit = 1 if (qlactlm2 == 1 )


*******************************************************************************
* (5) End of file
*******************************************************************************

keep  year statefip RegionI Employed income2 LowSat HealthSevere MentalHealthSevere Limit _finalwt _llcpwt
order  year statefip RegionI Employed income2 LowSat HealthSevere MentalHealthSevere Limit _finalwt _llcpwt

compress
save dta/brfss_clean, replace

log close
exit, clear
